<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Http\Api;

use stdClass;
use SupportPal\Marketplace\Exceptions\ApiException;
use SupportPal\Marketplace\Http\Request;

class Account
{
    protected Request $api;

    public function __construct(Request $api)
    {
        $this->api = $api;
    }

    /**
     * Fetch the client details.
     *
     * @param string $uuid
     * @return stdClass|null
     */
    public function client(string $uuid): ?stdClass
    {
        try {
            $response = $this->api->post('account', ['uuid' => $uuid]);
        } catch (ApiException $e) {
            return null;
        }

        $data = $this->handleResponse($response);

        if ($data === null) {
            return null;
        }

        return $data;
    }

    /**
     * Fetch the linked add-ons for a given license. Also verifies the account owns the license key.
     *
     * @param string $uuid
     * @param string $license
     * @return stdClass|null
     */
    public function license(string $uuid, string $license): ?stdClass
    {
        try {
            $response = $this->api->post('account/license', ['uuid' => $uuid, 'license' => $license]);
        } catch (ApiException $e) {
            return null;
        }

        $data = $this->handleResponse($response);

        if ($data === null) {
            return null;
        }

        return $data;
    }

    private function handleResponse(stdClass $response): ?stdClass
    {
        if (! $response->data instanceof stdClass) {
            return null;
        }

        return $response->data;
    }
}
