<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Http\Api;

use Illuminate\Support\Collection;
use SupportPal\Marketplace\Exceptions\ApiException;
use SupportPal\Marketplace\Http\Request;
use SupportPal\Marketplace\Models\Addon\Addon;

use function collect;

class Addons
{
    protected Request $api;

    /**
     * @param Request $api
     */
    public function __construct(Request $api)
    {
        $this->api = $api;
    }

    /**
     * Get the addons (cached for 3 hours).
     *
     * @param mixed[] $params
     * @return Collection<Addon>
     */
    public function get(array $params = []): Collection
    {
        try {
            $response = $this->api->get('addons', $params);
        } catch (ApiException $e) {
            return collect();
        }

        if (! isset($response->data)) {
            return collect();
        }

        $addons = [];
        foreach ($response->data as $addon) {
            $addons[] = new Addon($addon);
        }

        return collect($addons)->keyBy->getId();
    }
}
