<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Http\Api;

use SupportPal\Marketplace\Exceptions\ApiException;
use SupportPal\Marketplace\Http\Request;

class Auth
{
    protected Request $api;

    public function __construct(Request $api)
    {
        $this->api = $api;
    }

    /**
     * Check OAuth token is valid, and fetch UUID if so.
     *
     * @param string $token
     * @return string|null
     */
    public function login(string $token): ?string
    {
        try {
            $response = $this->api->post('auth/login', ['token' => $token]);
        } catch (ApiException $e) {
            return null;
        }

        if (! isset($response->message) && ! isset($response->data)) {
            return null;
        }

        if (isset($response->message) && $response->message !== 'Found account for token.') {
            return null;
        }

        return $response->data->uuid ?? null;
    }

    /**
     * Check if UUID is valid.
     *
     * @param string $uiid
     * @return bool
     */
    public function verify(string $uiid): bool
    {
        try {
            $response = $this->api->post('auth/verify', ['uuid' => $uiid]);
        } catch (ApiException $e) {
            return false;
        }

        if (! isset($response->message)) {
            return false;
        }

        return $response->message === 'Found account for UUID.';
    }
}
