<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Models\Addon;

use Illuminate\Support\Collection;
use stdClass;
use SupportPal\Marketplace\Models\Author;

use function array_map;
use function collect;
use function json_decode;
use function json_encode;

class Addon
{
    private int $id;

    private string $identifier;

    private string $name;

    private string $slug;

    private string $logoUri;

    private string $tagline;

    private Author $author;

    private Category $category;

    /** @var Collection<Tag> */
    private Collection $tags;

    private Version $version;

    /** @var mixed[]|null */
    private ?array $billing;

    public function __construct(stdClass $object)
    {
        $this->id = $object->id;
        $this->identifier = $object->identifier;
        $this->name = $object->name;
        $this->slug = $object->slug;
        $this->logoUri = $object->logo_uri;
        $this->tagline = $object->tagline;
        $this->author = new Author($object->author);
        $this->category = new Category($object->category);
        $this->tags = collect(array_map(function (stdClass $tag) {
            return new Tag($tag);
        }, $object->tags));
        $this->version = new Version($object->version);
        $this->billing = json_decode((string) json_encode($object->billing), true);
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getLogoUri(): string
    {
        return $this->logoUri;
    }

    public function getTagline(): string
    {
        return $this->tagline;
    }

    public function getAuthor(): Author
    {
        return $this->author;
    }

    public function getCategory(): Category
    {
        return $this->category;
    }

    public function getTags(): Collection
    {
        return $this->tags;
    }

    public function getVersion(): Version
    {
        return $this->version;
    }

    public function setVersion(Version $version): self
    {
        $this->version = $version;

        return $this;
    }

    /**
     * @return mixed[]|null
     */
    public function getBilling(): ?array
    {
        return $this->billing;
    }
}
