<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Models\Addon;

use Illuminate\Support\Collection;
use stdClass;

use function array_map;
use function collect;

class Version
{
    private string $value;

    private bool $stable;

    /** @var Collection<VersionArtifact> */
    private Collection $artifacts;

    private string $supportedProductVersion;

    public function __construct(stdClass $object)
    {
        $this->value = $object->value;
        $this->stable = $object->stable;
        $this->supportedProductVersion = $object->supported_product_version;
        $this->artifacts = collect(array_map(function (stdClass $artifact) {
            return new VersionArtifact($artifact);
        }, $object->artifacts));
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function isStable(): bool
    {
        return $this->stable;
    }

    /**
     * @return Collection<VersionArtifact>
     */
    public function getArtifacts(): Collection
    {
        return $this->artifacts;
    }

    public function getSupportedProductVersion(): string
    {
        return $this->supportedProductVersion;
    }
}
