<?php declare(strict_types=1);

namespace SupportPal\Marketplace\Models\Addon;

use stdClass;

class VersionArtifact
{
    private int $size;

    private string $contentType;

    private string $checksum;

    private string $downloadUrl;

    public function __construct(stdClass $object)
    {
        $this->size = $object->size;
        $this->contentType = $object->content_type;
        $this->checksum = $object->checksum;
        $this->downloadUrl = $object->download_url;
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function getContentType(): string
    {
        return $this->contentType;
    }

    public function getChecksum(): string
    {
        return $this->checksum;
    }

    public function getDownloadUrl(): string
    {
        return $this->downloadUrl;
    }
}
