<?php declare(strict_types=1);

/**
 * File CreatedProvider.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Events;

use Illuminate\Foundation\Events\Dispatchable;
use SupportPal\OAuth\Provider\Provider;

/**
 * Class CreatedProvider
 */
class CreatedProvider
{
    use Dispatchable;

    /** @var Provider */
    public $provider;

    /**
     * CreatedProvider constructor.
     *
     * @param Provider $provider
     */
    public function __construct(Provider $provider)
    {
        $this->provider = $provider;
    }
}
