<?php declare(strict_types=1);

/**
 * File Controller.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Http;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;
use SupportPal\OAuth\Exceptions\InvalidArgumentException;
use SupportPal\OAuth\Manager\Factory;
use SupportPal\OAuth\Provider\Provider;

use function abort;

/**
 * Class Controller
 */
class Controller extends BaseController
{
    /**
     * OAuth manager.
     *
     * @var Factory
     */
    protected $oauth;

    /**
     * Controller constructor.
     *
     * @param Factory $oauth
     */
    public function __construct(Factory $oauth)
    {
        $this->oauth = $oauth;
    }

    /**
     * Route the callback to the appropriate controller.
     *
     * @param Request $request
     * @param string $provider
     * @return mixed
     */
    public function callback(Request $request, $provider)
    {
        $name = $request->session()->pull(Provider::ACTION_SESSION_KEY);

        try {
            if (empty($name)) {
                throw new InvalidArgumentException('The session data has already been pulled.');
            }

            return $this->oauth
                ->getAction($name)
                ->run($request, $provider);
        } catch (InvalidArgumentException $e) {
            abort(400);
        }
    }
}
