<?php declare(strict_types=1);

/**
 * File Runnable.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Manager;

use function call_user_func;

/**
 * Class Runnable
 */
class Action
{
    /** @var callable */
    protected $callback;

    /**
     * Callback constructor.
     *
     * @param callable $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback;
    }

    /**
     * Run the callback.
     *
     * @param mixed[] $args
     * @return mixed
     */
    public function run(...$args)
    {
        return call_user_func($this->callback, ...$args);
    }
}
