<?php declare(strict_types=1);

/**
 * File OAuthServiceProvider.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth;

use Illuminate\Support\ServiceProvider;
use SupportPal\OAuth\Manager\Factory;
use SupportPal\OAuth\Manager\OAuth;

/**
 * Class OAuthServiceProvider
 */
class OAuthServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(Factory::class, function ($app) {
            return new OAuth($app);
        });
    }

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadRoutes();
    }

    /**
     * Load the application routes.
     *
     * @return void
     */
    protected function loadRoutes()
    {
        $params = [
            'prefix'     => 'oauth',
            'middleware' => ['web'],
        ];

        $this->app['router']->group($params, function ($router) {
            $router->get('/{provider}/callback', [
                'as'   => 'vendor.supportpal.oauth.callback',
                'uses' => '\SupportPal\OAuth\Http\Controller@callback'
            ]);
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [Factory::class];
    }
}
