<?php declare(strict_types=1);

/**
 * File Facebook.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider\Facebook;

use League\OAuth2\Client\Provider\Facebook as FacebookProvider;
use SupportPal\OAuth\Exceptions\InvalidStateException;
use SupportPal\OAuth\Provider\Provider;
use SupportPal\OAuth\User\OAuth2User;
use SupportPal\OAuth\User\User;

/**
 * Class Facebook
 */
class Facebook extends Provider
{
    /**
     * Get the User instance for the authenticated user.
     *
     * @return User
     */
    public function user()
    {
        if ($this->hasInvalidState()) {
            throw new InvalidStateException;
        }

        $token = $this->getServer()->getAccessToken('authorization_code', [
            'code' => $this->request->input('code')
        ]);

        $user = $this->getServer()->getResourceOwner($token);

        return (new OAuth2User)
            ->setRaw($user->toArray())
            ->setToken($token->getToken())
            ->setRefreshToken($token->getRefreshToken())
            ->setExpiresIn($token->getExpires())
            ->map([
                'id'              => $user->getId(),
                'nickname'        => null,
                'name'            => $user->getName(),
                'email'           => $user->getEmail(),
                'avatar'          => $user->getPictureUrl(),
            ]);
    }

    /**
     * Get OAuth server instance.
     *
     * @return FacebookProvider
     */
    public function getServer(): FacebookProvider
    {
        return $this->server;
    }
}
