<?php declare(strict_types=1);

/**
 * File Server.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider\Facebook;

use League\OAuth2\Client\Provider;
use SupportPal\OAuth\Provider\Server as Contract;

/**
 * Class Server
 */
class Server extends Provider\Facebook implements Contract
{
    /**
     * Set client ID.
     *
     * @param string $id
     * @return $this
     */
    public function setClientId(string $id)
    {
        $this->clientId = $id;

        return $this;
    }

    /**
     * Set client secret.
     *
     * @param string $secret
     * @return $this
     */
    public function setClientSecret(string $secret)
    {
        $this->clientSecret = $secret;

        return $this;
    }

    /**
     * Builds the authorization URL.
     *
     * @param string[] $options
     * @return string
     */
    public function getAuthorisationUrl(array $options = [])
    {
        return $this->getAuthorizationUrl($options);
    }

    /**
     * Set redirect URI.
     *
     * @param string $redirectUri
     * @return static
     */
    public function setRedirectUri(string $redirectUri)
    {
        $this->redirectUri = $redirectUri;

        return $this;
    }
}
