<?php declare(strict_types=1);

/**
 * File MicrosoftResourceOwner.php
 *
 * Adapted from https://github.com/stevenmaguire/oauth2-microsoft
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider\Microsoft;

use Illuminate\Support\Arr;
use League\OAuth2\Client\Provider\ResourceOwnerInterface;

/**
 * Class MicrosoftResourceOwner
 */
class MicrosoftResourceOwner implements ResourceOwnerInterface
{
    /**
     * Raw response
     *
     * @var array
     */
    protected $response;

    /**
     * Creates new resource owner.
     *
     * @param mixed[] $response
     */
    public function __construct(array $response = array())
    {
        $this->response = $response;
    }

    /**
     * Get user id
     *
     * @return string|null
     */
    public function getId()
    {
        return Arr::get($this->response, 'id');
    }

    /**
     * Get user email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return Arr::get($this->response, 'userPrincipalName');
    }

    /**
     * Get user firstname
     *
     * @return string|null
     */
    public function getFirstname()
    {
        return Arr::get($this->response, 'givenName');
    }

    /**
     * Get user lastname
     *
     * @return string|null
     */
    public function getLastname()
    {
        return Arr::get($this->response, 'surname');
    }

    /**
     * Get user name
     *
     * @return string|null
     */
    public function getName()
    {
        return Arr::get($this->response, 'displayName');
    }

    /**
     * Return all of the owner details available as an array.
     *
     * @return array
     */
    public function toArray()
    {
        return $this->response;
    }
}
