<?php declare(strict_types=1);

/**
 * File Provider.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider;

use GuzzleHttp\ClientInterface as Client;
use League\OAuth2\Client\Token\AccessTokenInterface;

/**
 * Interface Server
 */
interface Server
{
    /**
     * Set the Guzzle HTTP client.
     *
     * @param Client $client
     * @return static
     */
    public function setHttpClient(Client $client);

    /**
     * Set client ID
     *
     * @param string $id
     * @return static
     */
    public function setClientId(string $id);

    /**
     * Set client secret.
     *
     * @param string $secret
     * @return static
     */
    public function setClientSecret(string $secret);

    /**
     * Set redirect URI.
     *
     * @param string $redirectUri
     * @return static
     */
    public function setRedirectUri(string $redirectUri);

    /**
     * Builds the authorization URL.
     *
     * @param string[] $options
     * @return string
     */
    public function getAuthorisationUrl(array $options = []);

    /**
     * Requests an access token.
     *
     * @param  mixed $grant
     * @param  mixed[] $options
     * @return AccessTokenInterface
     */
    public function getAccessToken($grant, array $options = []);
}
