<?php declare(strict_types=1);

/**
 * File Steam.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider\Steam;

use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Arr;
use SupportPal\OAuth\Provider\Provider;
use SupportPal\OAuth\User\OAuth1User;
use SupportPal\OAuth\User\User;

use function redirect;

/**
 * Class Steam
 */
class Steam extends Provider
{
    /**
     * Redirect to the OAuth provider.
     *
     * @param string $action Name of an action.
     * @param string[] $options
     * @return RedirectResponse
     */
    public function redirect(string $action, array $options = [])
    {
        // Store the name of the action we want to call after the OAuth flow.
        $this->storeAction($action);

        return redirect()->to($this->getServer()->getAuthorisationUrl());
    }

    /**
     * Get the User instance for the authenticated user.
     *
     * @return User
     */
    public function user()
    {
        $user = $this->getServer()->getResourceOwner();

        return (new OAuth1User)
            ->setRaw($user)
            ->map([
                'id'       => $user['steamid'],
                'nickname' => Arr::get($user, 'personaname'),
                'name'     => Arr::get($user, 'realname'),
                'email'    => null,
                'avatar'   => Arr::get($user, 'avatarmedium'),
            ]);
    }

    /**
     * Server instance.
     *
     * @return Server
     */
    public function getServer(): Server
    {
        return $this->server;
    }
}
