<?php declare(strict_types=1);

/**
 * File Twitter.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\Provider\Twitter;

use GuzzleHttp\ClientInterface as Client;
use League\OAuth1\Client\Server\Twitter as OAuth1Server;
use SupportPal\OAuth\Exceptions\InvalidArgumentException;
use SupportPal\OAuth\Exceptions\RuntimeException;
use SupportPal\OAuth\Provider\Server as Contract;

/**
 * Class Server
 */
class Server extends OAuth1Server implements Contract
{
    /**
     * Guzzle Http client.
     *
     * @var Client
     */
    protected $client;

    /**
     * Set the Guzzle HTTP client.
     *
     * @param Client $client
     * @return $this
     */
    public function setHttpClient(Client $client)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Creates a Guzzle HTTP client for the given URL.
     *
     * @return Client
     */
    public function createHttpClient()
    {
        if ($this->client === null) {
            return parent::createHttpClient();
        }

        return $this->client;
    }

    /**
     * Set client ID.
     *
     * @param string $id
     * @return void
     */
    public function setClientId(string $id)
    {
        throw new RuntimeException('Unsupported operation.');
    }

    /**
     * Set client secret.
     *
     * @param string $secret
     * @return void
     */
    public function setClientSecret(string $secret)
    {
        throw new RuntimeException('Unsupported operation.');
    }

    /**
     * Set redirect URI.
     *
     * @param string $redirectUri
     * @return $this
     */
    public function setRedirectUri(string $redirectUri)
    {
        throw new RuntimeException('Unsupported operation.');
    }

    /**
     * Builds the authorization URL.
     *
     * @param string[] $options
     * @return string
     */
    public function getAuthorisationUrl(array $options = [])
    {
        if (! isset($options[0])) {
            throw new InvalidArgumentException('The options parameter should contain one item with the token credentials.');
        }

        return $this->getAuthorizationUrl($options[0]);
    }

    /**
     * Requests an access token.
     *
     * @param mixed $grant
     * @param mixed[] $options
     * @throws RuntimeException
     */
    public function getAccessToken($grant, array $options = [])
    {
        throw new RuntimeException('Access tokens are not implemented in OAuth 1.');
    }
}
