<?php declare(strict_types=1);

namespace SupportPal\OAuth\Provider\Whmcs;

use Illuminate\Support\Arr;
use League\OAuth2\Client\Provider\ResourceOwnerInterface;

class ResourceOwner implements ResourceOwnerInterface
{
    /**
     * Raw response
     *
     * @var array
     */
    protected $response;

    /**
     * Creates new resource owner.
     *
     * @param mixed[] $response
     */
    public function __construct(array $response = array())
    {
        $this->response = $response;
    }

    /**
     * Get user id
     *
     * @return string|null
     */
    public function getId()
    {
        return Arr::get($this->response, 'sub');
    }

    /**
     * Get user email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return Arr::get($this->response, 'email');
    }

    /**
     * Get user firstname
     *
     * @return string|null
     */
    public function getFirstname()
    {
        return Arr::get($this->response, 'given_name');
    }

    /**
     * Get user lastname
     *
     * @return string|null
     */
    public function getLastname()
    {
        return Arr::get($this->response, 'family_name');
    }

    /**
     * Get user name
     *
     * @return string|null
     */
    public function getName()
    {
        return Arr::get($this->response, 'name');
    }

    /**
     * Return all of the owner details available as an array.
     *
     * @return array
     */
    public function toArray()
    {
        return $this->response;
    }
}
