<?php declare(strict_types=1);

namespace SupportPal\OAuth\Provider\Whmcs;

use SupportPal\OAuth\Exceptions\InvalidStateException;
use SupportPal\OAuth\Provider\Provider;
use SupportPal\OAuth\User\OAuth2User;
use SupportPal\OAuth\User\User;

class Whmcs extends Provider
{
    /**
     * Get the User instance for the authenticated user.
     *
     * @return User
     */
    public function user()
    {
        if ($this->hasInvalidState()) {
            throw new InvalidStateException;
        }

        $token = $this->getServer()->getAccessToken('authorization_code', [
            'code'  => $this->request->input('code')
        ]);

        $user = $this->getServer()->getResourceOwner($token);

        return (new OAuth2User)
            ->setRaw($user->toArray())
            ->setToken($token->getToken())
            ->setRefreshToken($token->getRefreshToken())
            ->setExpiresIn($token->getExpires())
            ->map([
                'id'              => $user->getId(),
                'nickname'        => null,
                'name'            => $user->getName(),
                'email'           => $user->getEmail(),
                'avatar'          => null,
            ]);
    }

    /**
     * OAuth server instance.
     *
     * @return Server
     */
    public function getServer(): Server
    {
        return $this->server;
    }
}
