<?php declare(strict_types=1);

namespace SupportPal\OAuth\Token;

use RuntimeException;

use function time;

class AccessToken extends \League\OAuth2\Client\Token\AccessToken
{
    public function hasNearlyExpired(int $leeway): bool
    {
        $expires = $this->getExpires();

        if (empty($expires)) {
            throw new RuntimeException('"expires" is not set on the token');
        }

        return $expires - $leeway < time();
    }
}
