<?php declare(strict_types=1);

/**
 * File Provider.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\OAuth\User;

/**
 * Class OAuth1User
 */
class OAuth1User extends User
{
    /**
     * The user's access token.
     *
     * @var string
     */
    public $token;

    /**
     * The user's access token secret.
     *
     * @var string
     */
    public $tokenSecret;

    /**
     * Set the token on the user.
     *
     * @param  string  $token
     * @return $this
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * Set token secret - only used in OAuth 1.0
     *
     * @param string $secret
     * @return $this
     */
    public function setTokenSecret($secret)
    {
        $this->tokenSecret = $secret;

        return $this;
    }
}
