<?php declare(strict_types=1);

namespace SupportPal\ProxyService\Config;

use Composer\CaBundle\CaBundle;

use function is_dir;

class StreamConfig extends Config
{
    /**
     * @return mixed[]
     */
    public function toArray()
    {
        $opts = [];

        if ($this->config->hasUri()) {
            $opts['http']['proxy'] = $this->config->getUri();
        }

        $caPathOrFile = CaBundle::getSystemCaRootBundlePath();
        if (is_dir($caPathOrFile)) {
            $opts['ssl']['capath'] = $caPathOrFile;
        } else {
            $opts['ssl']['cafile'] = $caPathOrFile;
        }

        return $opts;
    }
}
