<?php declare(strict_types=1);

return array(
    'encoding'      => 'UTF-8',
    'cachePath'     => storage_path().'/app/purifier_cache',
    'settings' => array(
        'default' => array(
            'HTML.SafeIframe'           => 'true',
            'URI.SafeIframeRegexp'      => '%^(http://|https://|//)(www.youtube.com/embed/|player.vimeo.com/video/)%',
            'AutoFormat.Linkify'        => true,
            'AutoFormat.AutoParagraph'  => false,
            'HTML.IframeAllowFullscreen' => true,
            'URI.AllowedSchemes'        => [
                'http'      => true,
                'https'     => true,
                'mailto'    => true,
                'ftp'       => true,
                'nntp'      => true,
                'news'      => true,
                'data'      => true,
            ],
            'CSS.AllowTricky'           => true,
        ),
        'selfservice' => array(
            'Attr.EnableID'             => true,
        ),
        'mailer' => [
            'AutoFormat.Linkify' => false
        ],
    ),
);
