<?php declare(strict_types=1);

/**
 * File Html5Config.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Purifier\Config;

use HTMLPurifier_HTML5Config;
use HTMLPurifier_Lexer_HTML5;

/**
 * Class Html5Config
 */
class Html5Config extends Config
{
    /**
     * HTML5 specific rules.
     */
    const RULES = [
        'HTML.IframeAllowFullscreen'
    ];

    /**
     * Make HTMLPurifier Config instance.
     *
     * @param array<string> $config
     * @return HTMLPurifier_HTML5Config
     */
    public function make(?array $config = null)
    {
        $config = HTMLPurifier_HTML5Config::create($this->merge($config));
        $config->set('Core.LexerImpl', new HTMLPurifier_Lexer_HTML5);

        return $config;
    }
}
