<?php declare(strict_types=1);

namespace SupportPal\Purifier\Injector;

use HTMLPurifier_Injector;
use HTMLPurifier_Token;

class LazyImageLoading extends HTMLPurifier_Injector
{
    public $name = __CLASS__;

    public $needed = array('img');

    /**
     * @param HTMLPurifier_Token $token
     */
    public function handleElement(&$token)
    {
        if (empty($token->name) || $token->name !== 'img') {
            return;
        }

        if (isset($token->attr['loading'])) {
            return;
        }

        $token->attr['loading'] = 'lazy';
    }
}
