<?php declare(strict_types=1);

/**
 * File PurifierServiceProvider.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace SupportPal\Purifier;

use Illuminate\Support\ServiceProvider;
use SupportPal\Purifier\Config\Html5Config;

use function config_path;
use function realpath;

/**
 * Class PurifierServiceProvider
 */
class PurifierServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Boot the service provider.
     *
     * @return null
     */
    public function boot()
    {
        $source = realpath(__DIR__.'/../config/purifier.php');

        $this->publishes([$source => config_path('purifier.php')]);

        $this->mergeConfigFrom($source, 'purifier');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('purifier', function ($app) {
            return new Purifier(new Html5Config($app['config']));
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['purifier'];
    }
}
