<?php

namespace SupportPal\Requirements\Translation;

interface Translator
{
    /**
     * Set the locale to translate into.
     *
     * @param  string  $locale
     * @return static
     */
    public function setLocale($locale);

    /**
     * Get the locale to translate into.
     *
     * @return string
     */
    public function getLocale();

    /**
     * A naive approach to loading language variables, before Laravel has initialised.
     * Note: this function has no support for namespaces or plurals!
     *
     * @param  Translation  $translation
     * @return null|string
     */
    public function translate(Translation $translation);
}
