<?php declare(strict_types=1);

namespace SupportPal\Support\Exception;

use LogicException;
use Throwable;

abstract class FileException extends LogicException implements FileAwareException
{
    private ?string $filePath;

    public function __construct(?string $filePath, string $message = '', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->filePath = $filePath;
    }

    public function getFilePath(): ?string
    {
        return $this->filePath;
    }
}
