<?php declare(strict_types=1);

namespace SupportPal\Support\Files;

use Symfony\Component\Process\PhpExecutableFinder as SymfonyPhpExecutableFinder;

use function array_merge;
use function substr;

use const PHP_SAPI;

class PhpExecutableFinder
{
    use ExecutableFinderConcerns;

    private SymfonyPhpExecutableFinder $executableFinder;

    public function __construct(SymfonyPhpExecutableFinder $executableFinder)
    {
        $this->executableFinder = $executableFinder;
    }

    public function find(): string
    {
        $res = $this->executableFinder->find(false);
        if ($res === false) {
            throw $this->binaryNotFoundException('php');
        }

        return $res;
    }

    /**
     * @return string[]
     */
    public function findWithArgs(): array
    {
        return array_merge([$this->find()], $this->getArguments());
    }

    /**
     * @return string[]
     */
    public function getArguments(): array
    {
        $args = array_merge($this->executableFinder->findArguments(), $this->getDirectives());
        if (substr(PHP_SAPI, 0, 3) === 'cgi') {
            $args = array_merge($args, $this->getCgiArguments());
        }

        return $args;
    }

    /**
     * @return string[]
     */
    private function getCgiArguments(): array
    {
        return [
            '-q',
        ];
    }

    /**
     * @return string[]
     */
    private function getDirectives(): array
    {
        return [
            '-d', 'html_errors=0',
            '-d', 'register_argc_argv=1',
            '-d', 'implicit_flush=1',
            '-d', 'max_execution_time=0',
        ];
    }
}
