<?php declare(strict_types=1);

namespace SupportPal\Support\Files;

use RuntimeException;
use SupportPal\Support\Exception\FileNotFoundException;
use Symfony\Component\Filesystem\Filesystem;

use function hash_file;
use function sprintf;

class Sha256FileHash
{
    private const ALGORITHM = 'sha256';

    /** @var Filesystem */
    private Filesystem $filesystem;

    public function __construct(Filesystem $filesystem)
    {
        $this->filesystem = $filesystem;
    }

    public function hash(string $pathname): string
    {
        if (! $this->filesystem->exists($pathname)) {
            throw new FileNotFoundException(sprintf('File "%s" does not exist.', $pathname));
        }

        $fileHash = hash_file(self::ALGORITHM, $pathname);
        if ($fileHash === false) {
            throw new RuntimeException(
                sprintf('Failed to generate "%s" hash for file "%s".', self::ALGORITHM, $pathname)
            );
        }

        return $fileHash;
    }
}
