<?php declare(strict_types=1);

namespace SupportPal\Support\Process;

use Closure;
use Psr\Log\LoggerInterface;
use Symfony\Component\Process\Process;

use function ini_set;
use function sprintf;
use function uniqid;

class ProcessHandler
{
    private LoggerInterface $logger;

    public function __construct(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function handle(
        Process $process,
        string $workingDirectory,
        ?int $timeout = null,
        ?callable $callback = null,
        ?string $pid = null
    ): Process {
        ini_set('memory_limit', '-1');
        $process->setWorkingDirectory($workingDirectory);
        $process->setTimeout($timeout);
        $pid = $pid ?? uniqid();
        $this->logger->info(sprintf('%s# %s', $workingDirectory, $process->getCommandLine()), ['pid' => $pid]);

        $process->run($callback ?? $this->logOutput($pid));

        return $process;
    }

    public function setLogger(LoggerInterface $logger): self
    {
        $this->logger = $logger;

        return $this;
    }

    private function logOutput(string $pid): Closure
    {
        return function ($type, $buffer) use ($pid) {
            if ($type === Process::OUT) {
                $this->logger->info($buffer, ['pid' => $pid]);
            } else {
                $this->logger->error($buffer, ['pid' => $pid]);
            }
        };
    }
}
