<?php declare(strict_types=1);

namespace SupportPal\Support;

use Illuminate\Database\Connection as DB;
use Illuminate\Support\Str as IlluminateStr;
use SupportPal\Support\Database\Connection;
use SupportPal\Support\Database\MySqlConnection;

class ServiceProvider extends \Illuminate\Support\ServiceProvider
{
    public function register(): void
    {
        parent::register();

        $this->overrideMySqlConnector();
    }

    public function boot(): void
    {
        IlluminateStr::mixin(new Str\Trim);
        IlluminateStr::mixin(new Str\AssertEqualIgnoringCase);
        IlluminateStr::mixin(new Str\RemoveAnsi);

        $this->loadTranslationsFrom(__DIR__ . '/../resources/lang', 'Support');
    }

    private function overrideMySqlConnector(): void
    {
        DB::resolverFor('mysql', function ($connection, $database, $prefix, $config) {
            return new MySqlConnection($connection, $database, $prefix, $config);
        });

        $this->app->bind(Connection::class, function ($app) {
            return $app['db.connection'];
        });
    }
}
