<?php declare(strict_types=1);

namespace SupportPal\Support\Utils;

use Illuminate\Support\Str;

use function env;

class DockerHelper
{
    private ?bool $isRunningInDocker = null;

    /**
     * Check if the application is running on Docker.
     */
    public function isRunningInDocker(): bool
    {
        if ($this->isRunningInDocker !== null) {
            return $this->isRunningInDocker;
        }

        // Added in 3.7.0.
        $env = env('SUPPORTPAL_ENV');
        if ($env !== null && Str::startsWith($env, 'docker-')) {
            return $this->isRunningInDocker = true;
        }

        // Fallback to WS_SERVICE_NAME which has been there since Docker deployments were first released.
        return $this->isRunningInDocker = env('WS_SERVICE_NAME') !== null;
    }
}
